// PageSetting485.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSetting485.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#define MIN_COM_COUNT 2


// CPageSetting485 dialog

IMPLEMENT_DYNAMIC(CPageSetting485, CDialog)

CPageSetting485::CPageSetting485(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSetting485::IDD, pParent)
{

}

CPageSetting485::~CPageSetting485()
{
}

void CPageSetting485::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_CboProtocol);
	DDX_Control(pDX, IDC_EDIT_DATABIT, m_EditDataBit);
	DDX_Control(pDX, IDC_EDIT_STOPBIT, m_EditStopBit);
	DDX_Control(pDX, IDC_EDIT_ADDRESS, m_EditAddress);
	DDX_Control(pDX, IDC_COMBO_BAUDRATE, m_CboBaudrate);
	DDX_Control(pDX, IDC_COMBO_CHECKRESULT, m_CboCheckResult);
	DDX_Control(pDX, IDC_COMBO_SERI, m_CboSeri);
	DDX_Control(pDX, IDC_COMBO_COMTYPE, m_cboComType);
}


BEGIN_MESSAGE_MAP(CPageSetting485, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SET485, &CPageSetting485::OnBnClickedButtonSet485)
	ON_CBN_SELCHANGE(IDC_COMBO_SERI, &CPageSetting485::OnCbnSelchangeComboSeri)
END_MESSAGE_MAP()


// CPageSetting485 message handlers

void CPageSetting485::OnBnClickedButtonSet485()
{
	if (m_lLogonID < 0)
	{
		AfxMessageBox(_T("Please Logon first"));
		return;
	}
	int i485Type = m_CboProtocol.GetCurSel();
	int iBaudRate = GetDlgItemInt(IDC_COMBO_BAUDRATE);
	int iCheckBit = m_CboCheckResult.GetCurSel();
	int iCom = m_CboSeri.GetCurSel();
	if (1 == iCom && FALSE == m_CboSeri.IsWindowEnabled())
	{
		iCom = 0;
	}
	int iAddress = -1;
	int iDataBit = -1;
	int iStopBit = -1;
	try//ת
	{
		CString strAddress;
		GetDlgItem(IDC_EDIT_ADDRESS)->GetWindowText(strAddress);
		iAddress = atoi(CT2CA(strAddress));
		if((iAddress < 1)||(iAddress > 255))		//ַ1~255
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_ADDRESS),_T(""),MB_OK|MB_TOPMOST);
			return;
		}
		iAddress -= 1;			//ʱַ1	20120217

		CString strDataBit;
		GetDlgItem(IDC_EDIT_DATABIT)->GetWindowText(strDataBit);
		iDataBit = atoi(CT2CA(strDataBit));
		if (iDataBit != 7 && iDataBit != 8 && iDataBit != 9)
		{
			MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
			return;
		}

		CString strStopBit;
		GetDlgItem(IDC_EDIT_STOPBIT)->GetWindowText(strStopBit);
		iStopBit = atoi(CT2CA(strStopBit));
		if (iStopBit != 1 && iStopBit != 2)
		{
			MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
			return;
		}
	}
	catch (...)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	int iRet = DEC_ClientSetCom(m_lLogonID, i485Type, iAddress, iBaudRate, iDataBit, iStopBit, iCheckBit, 0, iCom);
	if(0 == iRet)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
}

void  CPageSetting485::LoadSurfaceResource()
{
	m_CboProtocol.AddString(GetText(IDS_SETTING_TRANSPARENCE));
	m_CboProtocol.AddString(GetText(IDS_SETTING_PELCOP));
	m_CboProtocol.AddString(GetTextByLan("͸ͨԤ","Transparent Channel"));
	m_CboProtocol.AddString(GetTextByLan("Э","CGI Protocol"));
	m_CboProtocol.AddString(GetTextByLan("Э","Screen Ctrl Protocol"));

	m_CboBaudrate.AddString(_T("2400"));
	m_CboBaudrate.AddString(_T("4800"));
	m_CboBaudrate.AddString(_T("9600"));
	m_CboBaudrate.AddString(_T("19200"));
	m_CboBaudrate.AddString(_T("38400"));
	m_CboBaudrate.AddString(_T("57600"));
	m_CboCheckResult.AddString(GetText(IDS_SETTING_NONE));
    m_CboCheckResult.AddString(GetText(IDS_SETTING_ODD));
	m_CboCheckResult.AddString(GetText(IDS_SETTING_EVEN));
// 	m_CboCheckResult.AddString(_T("1"));
// 	m_CboCheckResult.AddString(_T("0"));
	SetDlgItemText(IDC_STATIC_PROTOCOL, GetText(IDS_SETTING_PROTOCOL));
	SetDlgItemText(IDC_STATIC_DATABIT, GetText(IDS_SETTING_DATABIT));
	SetDlgItemText(IDC_STATIC_ADDRESS, GetText(IDS_SETTING_ADDRESS));
	SetDlgItemText(IDC_STATIC_STOPBIT, GetText(IDS_SETTING_STOPBIT));
	SetDlgItemText(IDC_STATIC_BAUDRATE, GetText(IDS_SETTING_BAUDRATE));
	SetDlgItemText(IDC_STATIC_CHECKBIT, GetText(IDS_SETTING_CHECKBIT));
	SetDlgItemText(IDC_STATIC_485, GetText(IDS_COM_SET));
	SetDlgItemText(IDC_STATIC_SERI,GetText(IDS_SETTING_COM));
	SetDlgItemText(IDC_BUTTON_SET485,GetText(IDS_SETTING_SETALARM));

	m_cboComType.AddString(GetTextByLan("RS485","Transparent Channel"));
	m_cboComType.AddString(GetTextByLan("RS232̶","RS232 Green Side"));
	m_cboComType.AddString(GetTextByLan("RS232","RS232 Lan"));


}

int CPageSetting485::UpdateComInfo(int _iCom)
{
	//static TDECPARAM decParam = {0};
	//memset(&decParam,0,sizeof(decParam));
	//DEC_ClientGetDecoderPara(m_lLogonID,&decParam);
	ComParam tComParam = {0};
	tComParam.iSize = sizeof(ComParam);
	tComParam.iCom = _iCom;
	DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_COM_PARAM, &tComParam, sizeof(ComParam));
	m_CboProtocol.SetCurSel(tComParam.ucType);
	SetDlgItemInt(IDC_EDIT_ADDRESS, tComParam.ucAddress + 1);	//ʾַʱ1  20120217
	CString szBaudRate;
	szBaudRate.Format(_T("%d"), tComParam.iBaudrate);
	int iIndex = m_CboBaudrate.FindStringExact(-1, szBaudRate);
	m_CboBaudrate.SetCurSel(iIndex);
	CString szTemp1;
	szTemp1.Format(_T("%d"), (unsigned char*)(tComParam.ucDatabit));
	m_EditDataBit.SetWindowText(szTemp1);
	szTemp1.Format(_T("%d"), (unsigned char*)(tComParam.ucStopbit));
	m_EditStopBit.SetWindowText(szTemp1);
	m_CboCheckResult.SetCurSel(tComParam.ucCheckbit);
	m_cboComType.SetCurSel(tComParam.iComType);
	
	return 0;
}

int CPageSetting485::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
	int iCom = 0;
	m_CboSeri.ResetContent();
	//int iCount = _pdecParam->m_iComNumber;
	//if (iCount < MIN_COM_COUNT)   //豸
	//{
	//	iCount = MIN_COM_COUNT;
	//}
	for (int i = 0; i < _pdecParam->m_iComNumber; i++)
	{
		CString Name;
		Name.Format("RS485-%d", i+1);
		m_CboSeri.AddString(Name);
	}
	m_CboSeri.SetCurSel(0);
	m_CboProtocol.SetCurSel(_pdecParam->m_rs485type[iCom]);
	SetDlgItemInt(IDC_EDIT_ADDRESS, _pdecParam->m_rs485address[iCom] + 1);	//ʾַʱ1  20120217
	CString szBaudRate;
	szBaudRate.Format(_T("%d"), _pdecParam->m_rs485baudrate[iCom]);
	int iIndex = m_CboBaudrate.FindStringExact(-1, szBaudRate);
	m_CboBaudrate.SetCurSel(iIndex);
	CString szTemp1;
	szTemp1.Format(_T("%d"), (unsigned char*)(_pdecParam->m_rs485databit[iCom]));
    m_EditDataBit.SetWindowText(szTemp1);
	szTemp1.Format(_T("%d"), (unsigned char*)(_pdecParam->m_rs485stopbit[iCom]));
	m_EditStopBit.SetWindowText(szTemp1);
	m_CboCheckResult.SetCurSel(_pdecParam->m_rs485checkbit[iCom]);

	UpdateComInfo(iCom);
	
	//if (_pdecParam->m_iComNumber == 1)
	//{
	//	m_CboSeri.SetCurSel(1);			//ֻһڣĬϴ2һҵزѡ豸ѡ
	//	m_CboSeri.EnableWindow(FALSE);
	//}

	char cCap[64] = {0};
	DEC_ClientGetCapability(m_lLogonID,cCap);
	if(atoi(cCap) < CAP_6)					//TC_921S2_MP֮豸֧ʾ
	{
		GetDlgItem(IDC_STATIC_SERI)->ShowWindow(FALSE);
		GetDlgItem(IDC_COMBO_SERI)->ShowWindow(FALSE);
	}

    return 0;
}

BOOL CPageSetting485::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}


void CPageSetting485::OnCbnSelchangeComboSeri()
{
	UpdateComInfo(m_CboSeri.GetCurSel());
}

void CPageSetting485::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_RS485TYPE:
		{
			int iSelect = -1;
			if(pData->tParam.tDecParam.m_iComNumber == 1)
				iSelect = 0;
			else
				iSelect = m_CboSeri.GetCurSel();
			UpdateComInfo(iSelect);
		}
		break;
	}
}